<div id="whitelist-smart-tips">
  <h4><?php echo htmlspecialchars(t('Whitelists informations'),ENT_QUOTES,'UTF-8'); ?></h4>
  <?php if(count($permessi)>0) { ?>
    <h5><?php echo htmlspecialchars(t('Associated plate authorizations').': '.count($permessi),ENT_QUOTES,'UTF-8'); ?></h5>
    <h5><?php echo htmlspecialchars(t('Active plate authorizations').': '.count($permessiAttivi),ENT_QUOTES,'UTF-8'); ?></h5>
    <?php if(count($permessiAttivi)>0) { ?>
      <h4>
        <font color="red">
          <?php echo htmlspecialchars(t('Warning').','        ,ENT_QUOTES,'UTF-8'); ?>
        </font>
        <font color="orange">
          <?php echo htmlspecialchars(t('This plate authorizations cancel the white list violation').':',ENT_QUOTES,'UTF-8'); ?>
        </font>
      </h4>
      <?php if(AuthItem::countLike("plate_list_%")>0) { ?>
        <?php $printedPermit = 0; ?>
        <?php foreach($permessiAttivi as $p) { ?>
          <?php if($printedPermit > 0) { ?>
            <?php echo htmlspecialchars(',',ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($p->url_view)), array('target', '_blank'), array('title', ($p->DescrizionePermesso))), 'html5', 'UTF-8'); ?>>
            <div class="icon-ok-circle"></div>
            <?php echo htmlspecialchars($p->IDPermesso,ENT_QUOTES,'UTF-8'); ?>
          </a>
          <?php $printedPermit++; ?>
        <?php } ?>
        <br />
      <?php } ?>
    <?php } ?>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('target', '_blank'), array('href', (url('plateAuthorization/CheckWhitelistPlate', array('plate'=>$plate, 'time'=>tts($timestamp), 'nationality'=>$nationality, 'gate'=>$gate))))), 'html5', 'UTF-8'); ?>>
      <h4>
        <div class="icon-question"></div>
        <?php echo htmlspecialchars(t('Why'),ENT_QUOTES,'UTF-8'); ?>
        <div class="icon-question"></div>
      </h4>
    </a>
  <?php } ?>
  <?php if(count($permessi)<=0) { ?>
    <h5><?php echo htmlspecialchars(t('No plate authorization associated'),ENT_QUOTES,'UTF-8'); ?></h5>
  <?php } ?>
  <?php foreach(PlateList::getCurrentUserWhiteLists() as $l) { ?>
    <?php if($l->editable) { ?>
      <div class="row-fluid">
        <div class="span7">
          <?php $listName = $l->getListTitle(); ?>
          <div class="btn-group btn-block">
            <a class="btn btn-block btn-small dropdown-toggle" data-toggle="dropdown" href="#">
              <?php echo htmlspecialchars(t("Lista ") . $listName,ENT_QUOTES,'UTF-8'); ?>
              <span class="caret pull-right" style="margin-right: 7px;"></span>
            </a>
            <ul class="dropdown-menu" role="menu">
              <?php foreach(PlateAuthInsertProfile::model()->findAll() as $paip) { ?>
                <?php if(user()->checkAccess("plate_auth_insert_profile_".$paip->id) && $l->editable && ($paip->list_code==-1 || $paip->list_code==$l->code)) { ?>
                  <li>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/NewPlateAuthProfile', array('plateListId' => $l->code, 'plate'=>$plate, 'profileId'=>$paip->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars($paip->description,ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  </li>
                <?php } ?>
              <?php } ?>
              <li>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('target', '_blank'), array('href', (url('plateAuthorization/newWhitelist', array('plateListId'=>$l->code,'idIsCode'=>1, 'plate'=>$plate, 'refTimestamp'=>tts($timestamp), 'nationality'=>$nationality))))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars(t("Fast insert"),ENT_QUOTES,'UTF-8'); ?>
                </a>
              </li>
            </ul>
          </div>
          <br />
          <br />
        </div>
      </div>
    <?php } ?>
  <?php } ?>
  <?php if(paramdeep('validation','voidButton','enabled')) { ?>
    <?php if(count($permessiAttivi)>0) { ?>
      <script type="text/javascript">
      //<![CDATA[
        $(document).ready( function() {
          $('.btn-status-approved').addClass( 'hidden' );
          $('.btn-status-pending').addClass( 'hidden' );
          $('.btn-status-invalid').addClass( 'hidden' );
        } );
      //]]>
      </script>
    <?php } else { ?>
      <script type="text/javascript">
      //<![CDATA[
        $(document).ready( function() {
          $('.btn-status-approved').removeClass( 'hidden' );
          $('.btn-status-pending').removeClass( 'hidden' );
          $('.btn-status-invalid').removeClass( 'hidden' );
        } );
            
      //]]>
      </script>
    <?php } ?>
  <?php } ?>
</div>
