<?php

class UserSettingsInfo
{
  /**
   * @var string name for the setting 
   */
  public $key;
  /**
   * @var string type of setting (boolean, string, integer, class...)
   */
  public $type;
  /**
   * @var string group of the settings
   */
  public $group;
  /**
   * @var string description of the settings
   */
  public $description;
  
  /**
   * 
   * @param string $k key name for the setting 
   * @param string $t type of setting (boolean, string, integer, class...)
   * @param string $d description of the settings
   * @param string $g group of the settings
   */
  public function __construct($k, $t, $g = null, $d = null)
  {
    if(empty($g))
      $g = t('General');
    if(empty($d))
      $d = "$k ($t)";
    $this->key = $k;
    $this->type = $t;
    $this->group = $g;
    $this->description = $d;
  }
}