<?php

class Session extends ActiveRecord
{

  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  public function tableName()
  {
    return 'yii_session';
  }

  public function scopes()
  {
    return array(
      'expired' => array(
        'condition' => 'expire < :timestap',
        'params' => array(':timestap' => time()),
      ),
      'valid' => array(
        'condition' => 'expire >= :timestamp',
        'params' => array(':timestamp' => time()),
      )
    );
  }

  public function byUser(User $user)
  {
    $this->getDbCriteria()->mergeWith(
      array(
        'condition' => 'id_user = :user_id',
        'params' => array(':user_id' => $user->id),
      )
    );
    return $this;
  }

  public function linkToUser(User $user)
  {
    $this->id_user = $user->id;
    return $this->save();
  }

}
