<?php

/**
 * 
 * @property string $ID
 * @property string $id_event
 * @property string $id_behavior
 * @property string $validation_result
 * @property string $comment
 * @property string $epoch
 * @property string $violation_code
 *
 * @property Behavior behavior
 * @property Event event
 * @property ViolationDocument preview
 * @property ViolationDocument definitive
 * @property ViolationDocument[] violationDocuments
 * 
 */
class EventBehavior extends ActiveRecord
{

  const STATUS_NEW = "new";

  const STATUS_APPROVED = "approved";

  const STATUS_INVALID = "invalid";

  const STATUS_PENDING = "pending";

  const STATUS_VOID = "void";

  const STATUS_NO_VALIDATION = "no_validation";

  /**
   *
   * @param system $className          
   * @return EventBehavior
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  public function tableName()
  {
    return 'events_behavior';
  }

  public function scopes()
  {
  	
  	$t = $this->getTableAlias(false);
  	
    return array (
    	
        'toValidate' => array (
            'condition' => "$t.validation_result is null or $t.validation_result <> 'no_validation'" 
        ),
    		
    	'validated' => array (
    		'condition' => "$t.validation_result <> '' and $t.validation_result <> 'no_validation'"
    	),
    		
    	'approved' => array (
    		'condition' => "$t.validation_result = :result",
    		'params' => array (
    			':result' => self::STATUS_APPROVED
    		)
    	),
    	
    	'invalid' => array (
    		'condition' => "$t.validation_result = :result",
    		'params' => array (
    			':result' => self::STATUS_INVALID
    		)
    	),
    	
    	'pending' => array (
    		'condition' => "$t.validation_result = :result",
    		'params' => array (
    			':result' => self::STATUS_PENDING
    		)
    	),
    		
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'ID', $this->ID, true );
    $criteria->compare ( 'id_event', $this->id_event, true );
    $criteria->compare ( 'id_behavior', $this->id_behavior, true );
    $criteria->compare ( 'validation_result', $this->validation_result, true );
    $criteria->compare ( 'comment', $this->comment, true );
    $criteria->compare ( 'epoch', $this->epoch, true );
    $criteria->compare ( 'violation_code', $this->violation_code, true );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }

  public function rules()
  {
    return array (
        array (
            'validation_result',
            'required' 
        ),
        array (
            'violation_code',
            'requiredIfApprovedAndAvailableChoices' 
        ),
        array (
            'violation_code, validation_result, comment',
            'safe' 
        ) 
    );
  }

  public function requiredIfApproved($attribute, $params)
  {
    if (($this->validation_result == self::STATUS_APPROVED) && ($this->$attribute == ''))
      $this->addError ( $attribute, Yii::t ( 'yii', '{attribute} cannot be blank.', array (
          '{attribute}' => $this->getAttributeLabel ( $attribute ) 
      ) ) );
  }

  public function requiredIfApprovedAndAvailableChoices($attribute, $params)
  {
    if (($this->validation_result == self::STATUS_APPROVED) && ($this->$attribute == ''))
    {
      if (ViolationCode::hasChoicesForBehavior ( $this->id_behavior ) > 0)
        $this->addError ( $attribute, Yii::t ( 'yii', '{attribute} cannot be blank.', array (
            '{attribute}' => $this->getAttributeLabel ( $attribute ) 
        ) ) );
    }
  }

  public function relations()
  {
  	
  	$t = $this->getTableAlias(false);
  	
    return array (
        'behavior' => array (
            self::BELONGS_TO,
            'Behavior',
            'id_behavior' 
        ),
        'event' => array (
            self::BELONGS_TO,
            'Event',
            'id_event' 
        ),
        'preview' => array (
            self::HAS_ONE,
            'ViolationDocument',
            'id_event_behavior',
            'scopes' => 'previewAvailable' 
        ),
        'definitive' => array (
            self::HAS_ONE,
            'ViolationDocument',
            'id_event_behavior',
            'scopes' => 'definitiveAvailable' 
        ),
        'violationDocuments' => array (
            self::HAS_MANY,
            'ViolationDocument',
            'id_event_behavior',
        ),
    	'gateBehavior' => array (
    		self::HAS_MANY,
    		'GateBehavior',
    		'',
    		'on' => "eventBehaviors.id_behavior=GateBehavior.id_behavior"
    	)
    );
  }

  public function getStatus()
  {
    if ($this->isNew ())
      return self::STATUS_NEW;
    if ($this->isApproved ())
      return self::STATUS_APPROVED;
    if ($this->isInvalid ())
      return self::STATUS_INVALID;
    if ($this->isVoid ())
      return self::STATUS_VOID;
    if ($this->isPending ())
      return self::STATUS_PENDING;
    if ($this->notToValidate ())
      return self::STATUS_NO_VALIDATION;
  }

  public function isNew()
  {
    return (! isset ( $this->validation_result ) || ($this->validation_result == ''));
  }

  public function isApproved()
  {
    return (isset ( $this->validation_result ) && $this->validation_result == self::STATUS_APPROVED);
  }

  public function isInvalid()
  {
    return (isset ( $this->validation_result ) && $this->validation_result == self::STATUS_INVALID);
  }

  public function isVoid()
  {
    return (isset ( $this->validation_result ) && $this->validation_result == self::STATUS_VOID);
  }

  public function isPending()
  {
    return (isset ( $this->validation_result ) && $this->validation_result == self::STATUS_PENDING);
  }

  public function notToValidate()
  {
    return (isset ( $this->validation_result ) && $this->validation_result == self::STATUS_NO_VALIDATION);
  }

  public function suspend()
  {
    $this->validation_result = self::STATUS_PENDING;
    return $this->save ();
  }

  public function approve()
  {
    $this->validation_result = self::STATUS_APPROVED;
    return $this->save ();
  }
}
