<?php

/**
 * @property string function
 * @property integer line
 * @property string file
 * @property string class
 * @property object object
 * @property string type
 * @property array args
 */
class CCallStackFrame extends CArray
{
  public function __construct($row)
  {
    parent::__construct($row);
  }
}

class CCallStack
{
  /**
   * @var CCallStackFrame[]
   */
  public $stack = array();
  
  /**
   * @param int $options
   * @param int $limit
   */
  public function __construct()
  {
    foreach(debug_backtrace() as $row)
      $this->stack[] = new CCallStackFrame($row);
  }
  
  /**
   * @return number
   */
  public function count()
  {
    return count($this->stack);    
  }
  
  /**
   * @param integer $index
   * @return CCallStackFrame
   */
  public function get($index=0)
  {
    if($index<0 || $index>=$this->count())
      return null;
    return $this->stack[$index];
  }
  
  /**
   * @return CCallStackFrame
   */
  public function head()
  {
    return $this->get(0);
  }
  
  /**
   * @return CCallStackFrame
   */
  public function caller()
  {
    return $this->get(1);
  }
  
  public static function printStack()
  {
    $stack = new CCallStack();
    foreach($stack->stack as $frame)
    {
      //if($frame->function == 'getZtlBestLimitedRule' && $frame->class=='Gate')
        echo(_2str($frame->args));
    }
  }
}
