<h3>
  <?php echo htmlspecialchars(t('Transit'),ENT_QUOTES,'UTF-8'); ?>
  <?php echo htmlspecialchars('#',ENT_QUOTES,'UTF-8'); ?>
  <?php echo htmlspecialchars($event->ID,ENT_QUOTES,'UTF-8'); ?>
</h3>
<?php $signList = $event->speedLimitSignList;; ?>
<?php $lane = $event->LaneID + 1; ?>
<table class="table table-striped table-condensed">
  <tbody>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('License plate'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if(isset($form)) { ?>
          <?php if(Yii::app()->user->checkAccess('license_plate_visibility')) { ?>
            <?php echo $form->textFieldRow($event, 'Plate', array('labelOptions' => array('label' => false))); ?>
          <?php } else    { ?>
            <?php echo htmlspecialchars("#######",ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        <?php } else { ?>
          <?php if(Yii::app()->user->checkAccess('license_plate_visibility')) { ?>
            <?php echo htmlspecialchars($event->Plate,ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars("#######",ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Nationality'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if(isset($form)) { ?>
          <?php echo $form->dropDownListRow($event, 'custom_nationality', array_merge(array('' => ''), CountryList::localized()), array('labelOptions' => array('label' => false), 'class' => 'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Country...'))); ?>
        <?php } else { ?>
          <?php echo CountryFlag::tagForCountryCode($event->custom_nationality); ?>
          <?php echo htmlspecialchars(CountryList::getCountryName($event->custom_nationality),ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Class'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if(isset($form)) { ?>
          <?php echo $form->dropDownListRow($event, 'custom_vehicle_type', array_merge(array('' => ''), VehicleTypes::localized()), array('labelOptions' => array('label' => false), 'class' => 'span2 chzn-select', 'data-placeholder' => Yii::t('app', 'Class...'))); ?>
        <?php } else { ?>
          <?php echo VehicleTypes::tagForVehicleClass($event->custom_vehicle_type); ?>
          <?php echo htmlspecialchars(VehicleTypes::getClassName($event->custom_vehicle_type),ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Speed'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if($event->vehicleSpeed > 0) { ?>
          <?php echo htmlspecialchars(sprintf("%.2f", $event->vehicleSpeed),ENT_QUOTES,'UTF-8'); ?>
          <?php echo htmlspecialchars(t('km/h'),ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Colors'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php $colorSet = $event->colorSet; ?>
        <?php if (isset($colorSet) && $colorSet->computed) { ?>
          <?php $this->renderPartial('/shared/_colorSet', array('colors' => $colorSet->getColorsArray(3)))        ; ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Dangerous Goods'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if(isset($form)) { ?>
          <?php echo $form->textField($event, 'Kemler', array('class'=>'span')); ?>
        <?php } else if(isset($report)) { ?>
          <?php echo htmlspecialchars($event->Kemler,ENT_QUOTES,'UTF-8'); ?>
        <?php } else { ?>
          <?php echo $this->renderPartial('/shared/_kemlerCode', array('kemlerCode' => $event->Kemler)); ?>
        <?php } ?>
      </td>
    </tr>
    <?php if(Yii::app()->user->checkAccess('view_vehicle_landmarks'))       { ?>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Speed Signs'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <div class="speed-limit-form-box">
            <?php if(!is_null($signList)) { ?>
              <?php foreach($signList as $sign) { ?>
                <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'speed-limit-sign-icon-medium'), array('src', ((Yii::app()->baseUrl) . '/images/speed-limit-signals/' . $sign . '.png'))), 'html5', 'UTF-8'); ?> />
              <?php } ?>
            <?php } ?>
          </div>
        </td>
      </tr>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Rear panels'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <div class="rear-panel-form-box">
            <?php if($event->yellowBarType) { ?>
              <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'yellow-bar-sign-icon-medium'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-signs/yb_' . ($event->yellowBarType) . '.png'))), 'html5', 'UTF-8'); ?> />
            <?php } ?>
          </div>
        </td>
      </tr>
    <?php } ?>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Date'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(DateHelper::formatLocalDate($event->StartTime),ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Time'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(DateHelper::formatISO9075Time($event->StartTime),ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Lane'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if($lane > 0) { ?>
          <?php echo htmlspecialchars($lane,ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($event->gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
  </tbody>
</table>
