<?php

/**
 * This is the model class for table "spotspeed_article_wizard".
 *
 * The followings are the available columns in table 'spotspeed_article_wizard':
 * @property integer $id
 * @property string $original_vehicle_class
 * @property string $custom_vehicle_class
 * @property string $custom_plate_type
 * @property string $begin_time
 * @property string $end_time
 * @property integer $delta_speed_min
 * @property integer $delta_speed_max
 * @property integer $id_violation_code
 * @property ViolationCode violationCode
 */
class SpotSpeedArticleWizard extends ActiveRecord
{

  /**
   *
   * @param system $className          
   * @return SpotSpeedArticleWizard
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  public function tableName()
  {
    return 'spotspeed_article_wizard';
  }

  public function relations()
  {
    return array (
        'violationCode' => array (
            self::BELONGS_TO,
            'ViolationCode',
            'id_violation_code' 
        ) 
    );
  }

  /**
   *
   * @param string $vehicleClass          
   * @return SpotSpeedArticleWizard
   */
  public function byCustomVehicleType($vehicleClass)
  {
    $this->getDbCriteria ()
      ->mergeWith ( array (
        'condition' => "custom_vehicle_class = :vehicle_class or custom_vehicle_class = ''",
        'params' => array (
            ':vehicle_class' => $vehicleClass 
        ) 
    ) );
    return $this;
  }

  /**
   *
   * @param unknown $hasGoods          
   * @return SpotSpeedArticleWizard
   */
  public function hasGoods($hasGoods)
  {
    if (! isset ( $hasGoods ))
      return $this;
    
    $hasGoodsValue = 0;
    if ($hasGoods)
      $hasGoodsValue = 1;
    
    $this->getDbCriteria ()
      ->mergeWith ( array (
        'condition' => 'has_goods = :hasgoods',
        'params' => array (
            ':hasgoods' => $hasGoodsValue 
        ) 
    ) );
    return $this;
  }

  /**
   *
   * @param unknown $propertyType          
   * @return SpotSpeedArticleWizard
   */
  public function byCustomPropertyType($propertyType)
  {
    $this->getDbCriteria ()
      ->mergeWith ( array (
        'condition' => "custom_property_type = :property_type or custom_property_type = ''",
        'params' => array (
            ':property_type' => $propertyType 
        ) 
    ) );
    return $this;
  }

  /**
   *
   * @param unknown $theTime          
   * @return SpotSpeedArticleWizard
   */
  public function withinTime($theTime)
  {
    
    // $interval = new CDbCriteria();
    
    // $interval->compare('begin_time', '>='.$theTime->format(DateHelper::ISO9075_TIME));
    // $interval->compare('end_time', '<='.$theTime->format(DateHelper::ISO9075_TIME));
    
    // $this->getDbCriteria()->mergeWith($interval);
    $this->getDbCriteria ()
      ->mergeWith ( array (
        'condition' => 'CASE WHEN begin_time <= end_time THEN :the_time BETWEEN begin_time AND end_time ELSE :the_time >= begin_time OR :the_time <= end_time END',
        'params' => array (
            ':the_time' => $theTime->format ( DateHelper::ISO9075_TIME ) 
        ) 
    ) );
    
    return $this;
  }

  /**
   *
   * @param unknown $theSpeed          
   * @return SpotSpeedArticleWizard
   */
  public function withinSpeedInterval($theSpeed)
  {
    $this->getDbCriteria ()
      ->mergeWith ( array (
        'condition' => 'delta_speed_min < :delta_min AND delta_speed_max >= :delta_max',
        'params' => array (
            ':delta_min' => $theSpeed,
            ':delta_max' => $theSpeed 
        ) 
    ) );
    return $this;
  }

  /**
   *
   * @param unknown $customVehicleType          
   * @param unknown $customPropertyType          
   * @param unknown $challengedSpeedDelta          
   * @param string $time          
   * @param boolean $hasGoods          
   */
  public function suggestCodes($customVehicleType, $customPropertyType, $challengedSpeedDelta, $time, $hasGoods = null)
  {
    $suggestions = SpotSpeedArticleWizard::model ()->byCustomVehicleType ( $customVehicleType )
      ->byCustomPropertyType ( $customPropertyType )
      ->withinSpeedInterval ( floatval ( $challengedSpeedDelta ) )
      ->withinTime ( $time )
      ->hasGoods ( $hasGoods )
      //->with ( 'violationCode' )
      ->findAll ();
   
      
    
    
    return array_map ( function (SpotSpeedArticleWizard $suggestion)
    {
      return $suggestion->violationCode;
    }, $suggestions );
  }
}
