<?php
/**
 * This is the model class for table "event_reporting".
 *
 * The followings are the available columns in table 'event_reporting':
 * @property integer $id
 * @property string $name
 * @property string $description
 * @property string $code
 * @property datetime $export_expiry_date
 
 */
class EventServerRegistration extends RegActiveRecord 
{
 

  /**
   * 
   * @param system $className
   * @return Alert alert's model
   */
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  public function tableName()
  {
    return 'event_server';
  }

  public function rules()
  {
    return array(
     );
  }

  public function relations()
  {
	 return array (
	        'eventServer' => array (
	            self::HAS_MANY,
	            'ExportedEvents',
	             'id_event_server'
	        ),
	       
	    );
  }

  public function scopes()
  {
    return array(
    );
  }

  public function behaviors()
  {

    return array('edatetimebehavior' => array('class' => 'ext.EDateTimeBehavior'));
  	
  }

  public function myAttributeLabels()
  {
    return array(

    );
  }
  
  public function byId($idServer)
  {
  	$this->getDbCriteria()->mergeWith(array(
  			'condition' => 'id = :id_server',
  			'params' => array(':id_server' => $idServer),
  	));
  	return $this;
  }
  

  
  public function byCode($code)
  {
  	$this->getDbCriteria()->mergeWith(array(
  			'condition' => 'code = :code',
  			'params' => array(':code' => $code),
  	));
  	return $this;
  }
  
  public function byMe()
  {
	$es_id_loaded = kria_load_secret('event_server_id');
	if(isEmpty($es_id_loaded))
		return null;
	
	return self::byCode($es_id_loaded);
  }

}
