<?php

class WorkPeriodController extends Controller
{

  public function actionIndex()
  {
    $all = false;
    
    $criteria = WorkPeriod::model ()->byUser ( Yii::app ()->user )
      ->orderByLoginTime ()
      ->getDbCriteria ();
    
    $dataProvider = new CActiveDataProvider ( 'workPeriod', array (
        'criteria' => $criteria,
        'pagination' => array (
            'pageSize' => 12 
        ) 
    ) );
    
    $this->render ( 'index', array (
        'dataProvider' => $dataProvider 
    ) );
  }

  public function actionAll()
  {
    access_denied_check('work_period_view_all');
    
    $all = true;
    
    $criteria = WorkPeriod::model ()->orderByLoginTime ()
      ->getDbCriteria ();
    
    $dataProvider = new CActiveDataProvider ( 'workPeriod', array (
        'criteria' => $criteria,
        'pagination' => array (
            'pageSize' => 30 
        ) 
    ) );
    
    $this->render ( 'index', get_defined_vars () );
  }
}