<?php

class BehaviorController extends Controller
{

  public $layout = '//layouts/column2';

  /**
   * Displays a particular model.
   *
   * @param integer $id
   *          the ID of the model to be displayed
   */
  public function actionView($id)
  {
    access_denied_check ( 'behavior_view' );
    $this->render ( 'view', array (
        'model' => $this->loadModel ( $id ) 
    ) );
  }

  /**
   * Creates a new model.
   * If creation is successful, the browser will be redirected to the 'view' page.
   */
  public function actioncreatedefaults()
  {
    access_denied_check ( 'behavior_create' );
    
    foreach ( Behavior::getTags () as $varname => $tag )
    {
      /** @var Behavior $b */
      $b = Behavior::model ()->find ( 'tag=:t', array (
          ':t' => $tag 
      ) );
      if ($b == null)
      {
        $b = new Behavior ();
        $b->alarm_tag_name = $tag;
        $b->confirmable = 0;
        $b->description = $varname;
        $b->epoch = DateTimeEx::nows ();
        $b->tag = $tag;
        $b->name = createNiceName($tag);
        $b->insert ();
      }
    }
    
    $this->redirectTo ( 'behavior/admin' );
  }

  /**
   * Creates a new model.
   * If creation is successful, the browser will be redirected to the 'view' page.
   */
  public function actionCreate()
  {
    access_denied_check ( 'behavior_create' );
    $model = new Behavior ();
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['Behavior'] ))
    {
      $model->attributes = $_POST ['Behavior'];
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->ID 
        ) );
    }
    
    $this->render ( 'create', array (
        'model' => $model 
    ) );
  }

  /**
   * Updates a particular model.
   * If update is successful, the browser will be redirected to the 'view' page.
   *
   * @param integer $id
   *          the ID of the model to be updated
   */
  public function actionUpdate($id)
  {
    access_denied_check ( 'behavior_update' );
    $model = $this->loadModel ( $id );
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['Behavior'] ))
    {
      $model->attributes = $_POST ['Behavior'];
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->ID 
        ) );
    }
    
    $this->render ( 'update', array (
        'model' => $model 
    ) );
  }

  /**
   * Deletes a particular model.
   * If deletion is successful, the browser will be redirected to the 'admin' page.
   *
   * @param integer $id
   *          the ID of the model to be deleted
   */
  public function actionDelete($id)
  {
    access_denied_check ( 'behavior_delete' );
    $this->loadModel ( $id )
      ->delete ();
    
    $this->redirectTo ( 'behavior/admin' );
  }

  /**
   * Lists all models.
   */
  public function actionIndex()
  {
    $this->redirectTo ( 'Behavior/admin' );
  }

  /**
   * Manages all models.
   */
  public function actionAdmin()
  {
    access_denied_check ( 'behavior_manage' );
    
    $model = new Behavior ( 'search' );
    $model->unsetAttributes (); // clear any default values
    if (isset ( $_GET ['Behavior'] ))
      $model->attributes = $_GET ['Behavior'];
    
    $this->render ( 'admin', array (
        'model' => $model 
    ) );
  }

  /**
   * Returns the data model based on the primary key given in the GET variable.
   * If the data model is not found, an HTTP exception will be raised.
   *
   * @param
   *          integer the ID of the model to be loaded
   * @return Behavior the model found
   */
  public function loadModel($id)
  {
    $model = Behavior::model ()->findByPk ( $id );
    if ($model === null)
      throw new CHttpException ( 404, 'The requested page does not exist.' );
    return $model;
  }
}
