<?php

Yii::import('application.vendors.*');

require_once('tcpdf/tcpdf.php');

class ReportPrinter extends CComponent
{
	// the ReportPrinter custom layout to use with render() functions in order
	// to produce the html which in turn will be compiled into a pdf (SEE BELOW)
	protected $layout = '//layouts/pdf-document';
	
	// this report styles
	protected $reportStyle = '/css/report/default/report.css';
	
	// this report main view
	protected $mainView = 'default/mainView';
	
	// this report sections
	protected $subviews = array(
		'report-cover-page-logo' => NULL,
		'report-cover-page-title' => NULL,
		'report-cover-page-subtitle' => 'default/_coverPageSubtitle',
		'report-cover-page-description' => NULL,
		'report-content' => 'default/_content',
		'confirmed-events' => 'default/_table_confirmed_events',
		'invalid-events' => 'default/_table_invalid_events',
	);
	
	// the first page containing confirmed events holds max this number of
	// events because we have the title on this page too
	protected $EVENT_COUNT_PER_FIRST_PAGE = 28;

	// subsequent pages holds this number of events, we don't have the title
	// here, so they can hold some more events
	protected $EVENT_COUNT_PER_PAGE = 33;
	
	public function printReport($title, $reportData)
	{
		// attach report html syles
		Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . $this->reportStyle);
		
		// add subviews to data
		$reportData['subviews'] = $this->subviews;
		
		// add total page count
		$reportData['pageCount'] = $this->getPageCount($reportData);
		
		//
		// render the report as an html document
		//
		// TODO - THIS IS A QUICK&DIRTY SOLUTION: we are temporarily
		// overwriting the default controller layout (the controller that is
		// actually calling this function) with our custom layout in order to
		// user the render() functions to produce the html source which in turn
		// will be compiled into a pdf.
		// once we are done with the html generation, we reset the controller
		// layout to its default value.
		$controllerLayout = Yii::app()->controller->layout;
		Yii::app()->controller->layout = $this->layout;
		$reportHtml = Yii::app()->controller->render($this->mainView, $reportData, true, true);
		Yii::app()->controller->layout = $controllerLayout;
		
		//die($reportHtml);
		
		// create PDF from html
		$pdf = $this->createPDF($title, $reportHtml);
		
		return $pdf;
	}
	
	protected function createPDF($title, $html)
	{
		
		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, TRUE, 'UTF-8', FALSE);
		
		//
		// set basic PDF info
		//
		
		// set creator
		$pdf->SetCreator(PDF_CREATOR);
		
		// set title
		$pdf->SetTitle($title);
		
		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		
		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
		
		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		
		// set font
		$pdf->SetFont('dejavusans');
		
		// add a page
		$pdf->AddPage();
		
		// output the HTML content
		$pdf->writeHTML($html, TRUE, FALSE, TRUE, FALSE, '');
		
		// close and return PDF document as a plain string
		return $pdf->Output($filename, 'S');
		
	}
	
	protected function getPageCount($reportData)
	{
		
		// the cover page
		$pageCount = 1;
		
		// the first page containing confirmed events (which holds
		// max EVENT_COUNT_PER_FIRST_PAGE events because we have the title on
		// this page too, subsequent pages holds EVENT_COUNT_PER_PAGE events),
		// so we have one page which holds up to EVENT_COUNT_PER_FIRST_PAGE
		// plus the necessary number of pages to holds the remaining events
		$pageCount+= 1 + ceil( ($reportData['counterOK'] - $this->EVENT_COUNT_PER_FIRST_PAGE) / $this->EVENT_COUNT_PER_PAGE);
		
		// the first page containing not confirmed events (which holds
		// max EVENT_COUNT_PER_FIRST_PAGE events because we have the title on
		// this page too, subsequent pages holds EVENT_COUNT_PER_PAGE events),
		// so we have one page which holds up to EVENT_COUNT_PER_FIRST_PAGE
		// plus the necessary number of pages to holds the remaining events
		$pageCount+= 1 + ceil( ($reportData['counterNO'] - $this->EVENT_COUNT_PER_FIRST_PAGE) / $this->EVENT_COUNT_PER_PAGE);
		
		return $pageCount;
		
	}
	
}

?>