<?php

class ExtensibleObject extends Object
{
  public $extensionFields = array();

  public function __get($name)
  {
    $methodName = "get{$name}";
    if(method_exists($this, $methodName))
      return $this->$methodName();
    if(isset($this->extensionFields[$name]))
      return $this->extensionFields[$name];
    return null;
  }
  public function __set($name,$value)
  {
    $methodName = "set{$name}";
    if(method_exists($this, $methodName))
      return $this->$methodName($value);
    $this->extensionFields[$name] = $value;
  }
  public function __isset($name)
  {
    return isset($this->extensionFields[$name]);
  }
  public function __unset($name)
  {
    unset($this->extensionFields[$name]);
  }
}
