<?php $signList = $alert->speedLimitSignList;; ?>
<tr>
  <td class="license-plate">
    <div class="licence-plate-box">
      <?php if($violation->nationalityCode != '') { ?>
        <?php $this->renderPartial('/shared/_countryFlag', array('isoCode' => $violation->nationalityCode)); ?>
      <?php } else { ?>
        <img width="16px" />
      <?php } ?>
      <?php if(Yii::app()->user->checkAccess('license_plate_visibility')) { ?>
        <?php echo htmlspecialchars($violation->Plate,ENT_QUOTES,'UTF-8'); ?>
      <?php } else { ?>
        <?php echo htmlspecialchars("#######",ENT_QUOTES,'UTF-8'); ?>
      <?php } ?>
    </div>
  </td>
  <td <?php echo MtHaml\Runtime::renderAttributes(array(array('title', ($violation->Gate))), 'html5', 'UTF-8'); ?>>
    <?php $gt = $violation->gate; ?>
    <?php if($gt != null) { ?>
      <?php if(empty($gt->short_name)) { ?>
        <?php echo htmlspecialchars($gt->Descrizione,ENT_QUOTES,'UTF-8'); ?>
      <?php } else { ?>
        <?php echo htmlspecialchars($gt->short_name,ENT_QUOTES,'UTF-8'); ?>
      <?php } ?>
    <?php } else { ?>
      <?php echo htmlspecialchars($violation->GateDescription,ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </td>
  <td>
    <?php echo htmlspecialchars(DateHelper::ensureObjectEx($violation->StartTime),ENT_QUOTES,'UTF-8'); ?>
  </td>
  <td>
    <?php echo htmlspecialchars($violation->Velocita,ENT_QUOTES,'UTF-8'); ?>
  </td>
  <td>
    <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'vehicle-class-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-classes/' . ($violation->VehicleClassIcon)))), 'html5', 'UTF-8'); ?> />
  </td>
  <td>
    <?php $colorSet = $violation->colorSet; ?>
    <?php if (isset($colorSet) && $colorSet->computed) { ?>
      <?php $this->renderPartial('/shared/_colorSet', array('colors' => $colorSet->getColorsArray(3))); ?>
    <?php } ?>
  </td>
  <td>
    <?php if(user()->checkAccess('media_view_photo')) { ?>
      <?php $photoBN = $violation->previewPhotoUrl; ?>
      <?php if(!empty($photoBN)) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Black/White photo'))), array('href', $photoBN), array('data-lightbox', ('violation-preview-' . ($violation->ID)))), 'html5', 'UTF-8'); ?>>
          <i class="icon-zoom-in"></i>
        </a>
      <?php } ?>
      <?php $photoCOL = $violation->previewColorPhotoUrl; ?>
      <?php if(!empty($photoCOL)) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Color photo'))), array('href', $photoCOL), array('data-lightbox', ('violation-preview-' . ($violation->ID)))), 'html5', 'UTF-8'); ?>>
          <i class="icon-zoom-in"></i>
        </a>
      <?php } ?>
    <?php } ?>
  </td>
</tr>
