<div id="plateauthrenew-page">
  <div class="page-header">
    <h2>
      <?php echo htmlspecialchars(t('Plate authorization renew'),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <div class="row">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',                   array('id'=>'plateauthrenew-search-form','action' => Yii::app()->createUrl('plateAuthorization/renew'),'method'=>'GET',)); ?>
      <?php if(isEmpty($newStartDate)) { ?>
        <?php $now = new DateTime(); ?>
        <?php $endDate = $item->DataFine; ?>
        <?php $startDate = ($endDate < $now) ? $now : $endDate; ?>
        <?php $startDateEx = new DateTimeEx($startDate); ?>
      <?php } else { ?>
        <?php $startDateEx = new DateTimeEx($newStartDate); ?>
      <?php } ?>
      <?php $startDateEx->setTime(0,0,0); ?>
      <?php $startDate = $startDateEx->toDateTime(); ?>
      <fieldset>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateAuthId'), array('value', ($item->IDPermesso))), 'html5', 'UTF-8'); ?> />
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'newStartDate'), array('value', $startDateEx)), 'html5', 'UTF-8'); ?> />
        <?php if(!isempty($returnUrl)) { ?>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'returnUrl'), array('value', $returnUrl)), 'html5', 'UTF-8'); ?> />
        <?php } ?>
        <h5><?php echo htmlspecialchars(t('Renewal size'),ENT_QUOTES,'UTF-8'); ?></h5>
        <?php echo CHtml::radioButton('renew_type', true, array('value'=>'from_duration'));; ?>
        <?php echo CHtml::dropDownList('renew_pick', 1, $renew_options, array('class'=>'span2'));; ?>
        <h5><?php echo htmlspecialchars(t('Renewal end date'),ENT_QUOTES,'UTF-8'); ?></h5>
        <?php echo CHtml::radioButton('renew_type', false, array('value'=>'from_date'));; ?>
        <div class="input-prepend input-append">
          <?php echo CHtml::textField('renew_date', $newEndDate, array('class'=>'date-picker span2',"readonly"=>"readonly")); ?>
          <div class="add-on icon-calendar"></div>
        </div>
        <div class="input-prepend input-append time-picker">
          <span class="add-on"></span>
          <?php echo CHtml::textField('renew_time', $newEndTime, array('class'=>'span1',"readonly"=>"readonly","data-format"=>Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])); ?>
          <span class="add-on">
            <div class="icon-time"></div>
          </span>
        </div>
        <button id="search-for-alert" class="pull-right btn" type="submit">
          <?php echo htmlspecialchars(t("Renew"),ENT_QUOTES,'UTF-8'); ?>
        </button>
      </fieldset>
      <table class="table table-condensed span12">
        <thead>
          <tr>
            <th><?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Surname'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Plate'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Start date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('End date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('New start date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Status')         ,ENT_QUOTES,'UTF-8'); ?></th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>
              <?php echo htmlspecialchars($item->Nome,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo htmlspecialchars($item->Cognome,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo htmlspecialchars($item->Targa,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo htmlspecialchars($item->DataInizio,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo htmlspecialchars($item->DataFine,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo htmlspecialchars($startDate->format(DateHelper::ISO9075_DATETIME),ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <font <?php echo MtHaml\Runtime::renderAttributes(array(array('color', ($item->statusColor))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars($item->statusText,ENT_QUOTES,'UTF-8'); ?>
              </font>
            </td>
          </tr>
        </tbody>
      </table>
      <?php $this->endWidget(); ?>
      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($item->url_return))), 'html5', 'UTF-8'); ?>>
        <?php echo htmlspecialchars(t('Go back'),ENT_QUOTES,'UTF-8'); ?>
      </a>
    </div>
  </div>
</div>
