<div class="page-header">
  <h2>
    <?php echo htmlspecialchars(Yii::t("app", "Impersonate"),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<table class="table table-condensed">
  <thead>
    <tr>
      <th><?php echo htmlspecialchars(t('Username'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Link'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Validity'),ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($users as $user) { ?>
      <tr>
        <td>
          <?php if($user->id == user()->id) { ?>
            <?php echo htmlspecialchars($user->getFullName(),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('user/view', array('id'=>$user->id))))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($user->getFullName(),ENT_QUOTES,'UTF-8'); ?>
            </a>
          <?php } ?>
        </td>
        <td>
          <?php if($user->id == user()->id) { ?>
            <?php echo htmlspecialchars($user->getImpersonationUrl(true),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($user->getImpersonationUrl(true))), array('target', '_blank'), array('onclick', 'return confirm(\'DO YOU CONFIRM?\');')), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($user->getImpersonationUrl(true),ENT_QUOTES,'UTF-8'); ?>
            </a>
          <?php } ?>
        </td>
        <td>
          <?php echo htmlspecialchars("$validFrom => $validTo",ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
