<div class="page-header">
  <h2>
    <div class="icon-eye-open"></div>
    <?php echo htmlspecialchars('Dynamic configuration',ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<h4><?php echo htmlspecialchars($filename.(fileExists($filename)?" (found)":" (NOT found)"),ENT_QUOTES,'UTF-8'); ?></h4>
<form method="POST">
  <table class="table table-condensed">
    <thead>
      <th><?php echo htmlspecialchars('Configuration',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Current status',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars('Change status',ENT_QUOTES,'UTF-8'); ?></th>
    </thead>
    <tbody>
      <?php foreach($dynconfig as $name => $status) { ?>
        <tr>
          <td><?php echo htmlspecialchars($name,ENT_QUOTES,'UTF-8'); ?></td>
          <td>
            <?php if($status) { ?>
              <font color="green"><?php echo htmlspecialchars('ENABLED',ENT_QUOTES,'UTF-8'); ?></font>
            <?php } else { ?>
              <font color="red"><?php echo htmlspecialchars('DISABLED',ENT_QUOTES,'UTF-8'); ?></font>
            <?php } ?>
          </td>
          <td>
            <select <?php echo MtHaml\Runtime::renderAttributes(array(array('name', $name)), 'html5', 'UTF-8'); ?>>
              <?php if($status) { ?>
                <option value="0"><?php echo htmlspecialchars('DISABLED',ENT_QUOTES,'UTF-8'); ?></option>
                <option value="1" selected="selected"><?php echo htmlspecialchars('ENABLED',ENT_QUOTES,'UTF-8'); ?></option>
              <?php } else { ?>
                <option value="0" selected="selected"><?php echo htmlspecialchars('DISABLED',ENT_QUOTES,'UTF-8'); ?></option>
                <option value="1"><?php echo htmlspecialchars('ENABLED',ENT_QUOTES,'UTF-8'); ?></option>
              <?php } ?>
            </select>
          </td>
        </tr>
      <?php } ?>
    </tbody>
  </table>
  <input type="submit" name="SET" value="SET" />
</form>
