<div>
  <table class="table table-striped table-condensed">
    <thead>
      <tr>
        <th><?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('To be confirmed'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Valid now'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Active'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Disabled'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(t('Total'),ENT_QUOTES,'UTF-8'); ?></th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($plateLists as $pl) { ?>
        <?php $stats = $pl->getPlateAuthsStats();    ; ?>
        <tr>
          <td>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/list?plateListId='.$pl->id)))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($pl->listTitle,ENT_QUOTES,'UTF-8'); ?>
            </a>
          </td>
          <td>
            <?php if(user()->checkAccess('plate_auth_status')) { ?>
              <?php $params = array('plateListId'=>$pl->code,'status'=>'tobeconfirmed','sort'=>'end_time_desc'); ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whitelistStatus', $params)))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars($stats['to_be_confirmed'],ENT_QUOTES,'UTF-8'); ?>
              </a>
            <?php } else { ?>
              <?php echo htmlspecialchars($stats['to_be_confirmed'],ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </td>
          <td>
            <?php if(user()->checkAccess('plate_auth_status')) { ?>
              <?php $params = array('plateListId'=>$pl->code,'status'=>'valid','sort'=>'end_time_desc'); ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whitelistStatus', $params)))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars($stats['valid'],ENT_QUOTES,'UTF-8'); ?>
              </a>
            <?php } else { ?>
              <?php echo htmlspecialchars($stats['valid'],ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </td>
          <td>
            <?php if(user()->checkAccess('plate_auth_status')) { ?>
              <?php $params = array('plateListId'=>$pl->code,'status'=>'enabled','sort'=>'end_time_desc'); ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whitelistStatus', $params)))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars($stats['enabled'],ENT_QUOTES,'UTF-8'); ?>
              </a>
            <?php } else { ?>
              <?php echo htmlspecialchars($stats['enabled'],ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </td>
          <td>
            <?php if(user()->checkAccess('plate_auth_status')) { ?>
              <?php $params = array('plateListId'=>$pl->code,'status'=>'disabled','sort'=>'end_time_desc'); ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whitelistStatus', $params)))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars($stats['disabled'],ENT_QUOTES,'UTF-8'); ?>
              </a>
            <?php } else { ?>
              <?php echo htmlspecialchars($stats['disabled'],ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </td>
          <td>
            <?php if(user()->checkAccess('plate_auth_status')) { ?>
              <?php $params = array('plateListId'=>$pl->code,'sort'=>'end_time_desc'); ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whitelistStatus', $params)))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars($stats['total'],ENT_QUOTES,'UTF-8'); ?>
              </a>
            <?php } else { ?>
              <?php echo htmlspecialchars($stats['total'],ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          </td>
        </tr>
      <?php } ?>
    </tbody>
  </table>
</div>
