<?php $now = DateHelper::ensureObjectEx(); ?>
<div class="event-reporting-summary">
  <ul class="unstyled inline">
    <li>
      <?php $t = t("Today's transits").' ('.$now->getToday()->toDateString().')'; ?>
      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'stats-day'), array('title', $t)), 'html5', 'UTF-8'); ?>>
        <b>
          <?php echo htmlspecialchars(t('D',null,'gateStatus'),ENT_QUOTES,'UTF-8'); ?>
        </b>
        <?php echo htmlspecialchars($this->getRecentTransitsDay(),ENT_QUOTES,'UTF-8'); ?>
      </div>
    </li>
    <li>
      <?php $t = t("This week's transits")." (".($now->getFirstDayOfWeek()->toDateString())." -> ".($now->getLastDayOfWeek()->toDateString()).")"; ?>
      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'stats-week'), array('title', $t)), 'html5', 'UTF-8'); ?>>
        <b>
          <?php echo htmlspecialchars(t('W',null,'gateStatus'),ENT_QUOTES,'UTF-8'); ?>
        </b>
        <?php echo htmlspecialchars($this->getRecentTransitsWeek(),ENT_QUOTES,'UTF-8'); ?>
      </div>
    </li>
    <li>
      <?php $t = t("This month's transits")." (".ucwords($now->getMonthName())." $now->year)"; ?>
      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'stats-month'), array('title', $t)), 'html5', 'UTF-8'); ?>>
        <b>
          <?php echo htmlspecialchars(t('M',null,'gateStatus'),ENT_QUOTES,'UTF-8'); ?>
        </b>
        <?php echo htmlspecialchars($this->getRecentTransitsMonth(),ENT_QUOTES,'UTF-8'); ?>
      </div>
    </li>
  </ul>
</div>
