<?php

class NewBlacklistForm extends FormModel {

    public $plate;
    public $vehicleModel;
    public $list_code;
    public $source;
    public $name;
    public $surname;
    public $email;
    public $address;
    public $city;
    public $phone;
    public $type;
    public $vehicleNationality;
    public $action;
    public $vehicleType;
    public $vehicleCategory;
    public $note;
    public $startDate;
    public $endDate;
    public $endDateBL;
    public $startTime;
    public $endTime;
    public $filterGate;
    public $filterTime;
    public $overwriteVehicleOwner;

    function __construct() {
        $tmp = new DateTime();

        $this->startDate = $tmp->format(getFormat_Date());
        $this->endDate = $tmp->format(getFormat_Date());

        $this->startTime = "00:00";
        $this->endTime = "23:59";

        $this->filterGate = -1;
        $this->filterTime = -1;

        $this->overwriteVehicleOwner = true;
    }

    /**
     * @return string
     */
    public function normalizePlates() {
        $this->plate = implode(PHP_EOL, plate_list_normalization($this->plate, PHP_EOL));
        return $this->plate;
    }

    /**
     *
     * @return string[]
     */
    public function getPlates() {
        return plate_list_normalization($this->normalizePlates());
    }

    /**
     * Declares attribute labels.
     */
    public function myAttributeLabels() {
        return array(
            'plate' => t('Plate'),
            'vehicleModel' => t('Model'),
            'startDateTime' => t('Start Date/Time'),
            'endDateTime' => t('End Date/Time'),
            'startDate' => t('Start date'),
            'endDate' => t('End date'),
            'startTime' => t('Start time'),
            'endTime' => t('End time'),
            'gates' => t('Gates'),
            'time' => t('Schedule'),
            'listGroup' => t('List'),
            'source' => t('Source'),
            'name' => t('Name'),
            'surname' => t('Surname'),
            'vehicleNationality' => t('Nationality'),
            'action' => t('Action'),
            'vehicleType' => t('Vehicle Type'),
            'vehicleCategory' => t('Alert type'),
            'notes' => t('Notes'),
            'type' => t('Type'),
            'filterGate' => t('Gate'),
            'filterTime' => t('Time Schedule'),
            'email' => t('Email'),
            'address' => t('Address'),
            'city' => t('City'),
            'phone' => t('Phone'),
            'overwriteVehicleOwner' => t('Bound to existing owner'),
        );
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('source, name, surname, vehicleNationality, action, vehicleType, vehicleCategory, note', 'length', 'max' => 250),
            //array('plate', 'match', 'pattern' =>'#^[A-Z0-9]*$#','message' => 'only capital letters and numbers','allowEmpty'=>false),
            array('startDate', 'required'),
            array('vehicleNationality', 'required'),
            array('endDate', 'required'),
            array('startTime', 'required'),
            array('endTime', 'required'),
            array('plate', 'required'),
            array('name', 'required'),
            array('surname', 'required'),
            array('type', 'whitelistPlateAuthTypeRequired'),
            array('filterGate', 'required'),
            array('filterTime', 'required'),
            array('startDate', 'dateTimeConsistency'),
            array('email', 'email'),
            array('plate,vehicleModel,list_code,source,name,surname,type,vehicleNationality,action,vehicleType,vehicleCategory,note,startDate,endDate,startTime,endTime,filterGate,filterTime,email,address,city,phone,overwriteVehicleOwner', 'safe'),
        );
    }

    public function whitelistPlateAuthTypeRequired($attribute, $params) {
        $list = PlateList::load($this->list_code, true, false);
        //logLine($list == null ? "non trovato $this->list_code":  "trovato $this->list_code");
        if ($list != null)
            if ($list->mode == PlateList::MODE_WHITE_LIST) {
                if (isEmpty($this->type)) {
                    $this->addError($attribute, t('Type is required'));
                }
            }
    }

    public function dateTimeConsistency($attribute, $params) {
        $start = $this->getStartDateTime();
        $end = $this->getEndDateTime();

        $check = $start->compare($end);
        if ($check > 0)
            $this->addError($attribute, t('Start date/time must be less then end date/time'));
    }

    /**
     * @return integer
     */
    public function getStartTimestamp() {
        return $this->getStartDateTime()->toDateTime()->getTimestamp();
    }

    /**
     * @return integer
     */
    public function getEndTimestamp() {
        return $this->getEndDateTime()->toDateTime()->getTimestamp();
    }

    /**
     * @return DateTimeEx
     */
    public function getStartDateTime() {
        return DateHelper::ensureObjectEx(DateTime::createFromFormat(getFormat_DateTime() . ':s', "$this->startDate {$this->startTime}:00"));
    }

    /**
     * @return DateTimeEx
     */
    public function getEndDateTime() {
        return DateHelper::ensureObjectEx(DateTime::createFromFormat(getFormat_DateTime() . ':s', "$this->endDate {$this->endTime}:59"));
    }

}
