<?php

class EventsStatisticsSearchForm extends CFormModel
{
	public $startDateTime;
	public $endDateTime;
	public $gates;
	public $startTimeSlot;
	public $endTimeSlot;
	
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('startDateTime, endDateTime', 'required'),
			array('startDateTime, endDateTime', 'date', 'format' => 'd/M/yyyy H:mm'),
			array('startDateTime', 'validateDateTimeRange'),
			array('startTimeSlot, endTimeSlot', 'date', 'format' => 'H:mm'),
			array('startTimeSlot', 'validateTimeSlotRange'),
			array('gates', 'type', 'type' => 'array'),
			array('startDateTime, endDateTime, gates, startTimeSlot, endTimeSlot', 'safe')
		);
	}
	
	public function validateDateTimeRange($attribute, $params)
	{
		$start = DateHelper::ensureObjectEx(DateTime::createFromFormat(getFormat_DateTime(), $this->startDateTime));
		$end   = DateHelper::ensureObjectEx(DateTime::createFromFormat(getFormat_DateTime(), $this->endDateTime));
			
		$check = $start->compare($end);
		if ($check > 0) {
				
			$this->addError($attribute, t('Start date/time must be less than End date/time'));
			
		}
	}
	
	public function validateTimeSlotRange($attribute, $params)
	{
		if (
			(!empty($this->startTimeSlot) && empty($this->endTimeSlot))
			||
			(!empty($this->endTimeSlot) && empty($this->startTimeSlot))
		) {
			
			$this->addError($attribute, t('Start time slot and End time slot must both be set'));
			
			return;
		}
		
		$start = DateHelper::ensureObjectEx(DateTime::createFromFormat(getFormat_Time(), $this->startTimeSlot));
		$end   = DateHelper::ensureObjectEx(DateTime::createFromFormat(getFormat_Time(), $this->endTimeSlot));
		
		$check = $start->compare($end);
		if ($check > 0) {
			
			$this->addError($attribute, t('Start time slot must be less than End time slot'));
			
			return;
		}
	}
	
}

?>