<?php
require_once 'globals.php';

class m130801_075114_fill_gate_on_event_reporting_table extends MyDbMigration
{
  public function up()
  {
    $alerts = Alert::model()->findAll();
    foreach($alerts as $alert)
    {
      if ($alert->hasAssociatedEvent())
      {
        try {
          $event = $alert->associatedEvent;
          $alert->gate = $event->gate->Gate;
          $alert->save();
        }
        catch(Exception $e) {
          echo "{$e->getMessage()}\n";
        }
      }
    }
  }

  public function down()
  {
    $this->execute('update event_reporting set gate = NULL');
  }

}
