<?php

class CountryFlag
{
  public static function tagForCountryCode($isoCode)
  {
  	if(is_null($isoCode))
  		return null;
  	
    $countryList = CountryList::localized();
    $imageUrl = self::imageUrl($isoCode);
    
    $isoCode = strtoupper($isoCode);
    
    $title = $countryList[$isoCode];

    return CHtml::image($imageUrl, $isoCode);
  }

  private static function imageUrl($isoCode)
  {
    $isoCode = strtolower($isoCode);
    return Yii::app()->baseUrl."/images/country-flags/16x16/{$isoCode}.png";
  }
}
