<?php
/**
 * Author: Duc Nguyen Ta Quang <ducntq@gmail.com>
 *
 * Automatically convert date and datetime field to PHP5 DateTime object
 *
 * Inspired from DateTimeI18NBehavior
 *
 * Date: 5/15/12
 * Time: 2:14 PM
 * Version: 1.0.0
 * Tested with yii-1.1.10.r3566
 */

class EDateTimeBehavior extends CActiveRecordBehavior
{
  private $mySqlDateFormat = 'Y-m-d';
  private $mySqlDateTimeFormat = 'Y-m-d H:i:s';

  public function afterFind($event)
  {
    foreach($event->sender->tableSchema->columns as $columnName => $column){
      if (($column->dbType != 'date') && ($column->dbType != 'datetime'))
        continue;

      if (!is_string($event->sender->$columnName)){
        $event->sender->$columnName = null;
        continue;
      }
      $event->sender->$columnName = new DateTime($event->sender->$columnName);
    }
  }

  public function beforeSave($event)
  {
    foreach($event->sender->tableSchema->columns as $columnName => $column) {
      if (($column->dbType != 'date') && ($column->dbType != 'datetime'))
        continue;

      if (isset($event->sender->$columnName) && !is_string($event->sender->$columnName) && get_class($event->sender->$columnName) == 'DateTime')
      {
        if ($column->dbType == 'date')
        {
          $sqlDate = $event->sender->$columnName->format($this->mySqlDateFormat);
          $event->sender->$columnName = $sqlDate;
        }
        else
        {
          $sqlDateTime = $event->sender->$columnName->format($this->mySqlDateTimeFormat);
          $event->sender->$columnName = $sqlDateTime;
        }
      }
    }
  }

  public function afterSave($event) {
    $this->afterFind($event);
  }

}
