<?php

class VehicleTraceController extends Controller {
    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    //public $layout='//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            array('application.filters.SyslogFilter',),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {

        $event = $this->loadModel($id);

        if (isset($event->alert)) {
            $operator = Yii::app()->user->model;
            $this->render('/alert/viewVehicleTrace', array('alert' => $event->alert, 'event' => $event, 'editEnable' => $event->alert->canEdit($operator->id)));
            return;
        }

        $this->render('viewVehicleTrace', array('event' => $event));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new VehicleTrace;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['VehicleTrace'])) {
            $model->attributes = $_POST['VehicleTrace'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->ID));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['VehicleTrace'])) {
            $model->attributes = $_POST['VehicleTrace'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->ID));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
            // we only allow deletion via POST request
            $this->loadModel($id)->delete();

            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('VehicleTrace');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new VehicleTrace('search', $model->startTimeSordOrder);
        $model->unsetAttributes();  // clear any default values

        if (isset($_GET['VehicleTrace']))
            $model->attributes = $_GET['VehicleTrace'];
        else
            $model->ID = -1;

        $model->searchBookmarked = $_REQUEST['searchBookmarked'] == 1;
        $model->startTimeSordOrder = $_GET['startTimeSordOrder'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     * @return VehicleTrace
     */
    public function loadModel($id) {
        $model = VehicleTrace::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'vehicle-trace-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionExportToPdf($id) {

        $event = $this->loadModel($id);

        if (isset($event->alert)) {
            $operator = Yii::app()->user->model;

            $html = $this->renderPartial('/alert/viewVehicleTrace', array('alert' => $event->alert, 'event' => $event, 'editEnable' => $event->alert->canEdit($operator->id)), true);
        } else {

            $this->layout = '//layouts/pdf';
            $html = $this->render('viewVehicleTracePdf', array('event' => $event), true);
            $html = gzcompress($html, 9);

            $fileTitle = t('Event') . "_" . $id;

            Yii::app()->user->setState('htmlPdf', $html);
            $this->redirect(array('pdfExport/ExportPdf', 'htmlVar' => 'htmlPdf', 'title' => $fileTitle));
        }
    }

}
