<?php

/**
 * Contains fields for the file unpload, same fields as $_FILES
 * @property boolean success
 * @property boolean exists
 * @property string extension
 * @property string errorString
 */
class FileUpload extends ExtensibleObject
{
  /**
   * The original key from the $_FILES array.
   * @var string
   */
  public $key;
  /**
   * The original name of the file on the client machine.
   * @var string
   */
  public $name;
  /**
   * The mime type of the file, if the browser provided this information. An example would be "image/gif". This mime type is however not checked on the PHP side and therefore don't take its value for granted.
   * @var string
   */
  public $type;
  /**
   * The size, in bytes, of the uploaded file.
   * @var string
   */
  public $size;
  /**
   * The temporary filename of the file in which the uploaded file was stored on the server.
   * @var string
   */
  public $tmp_name;
  /**
   * The error code associated with this file upload.
   * @var string
   */
  public $error;

  /**
   * Moves an uploaded file to a new location.
   * @param string $filename The destination of the moved file.
   * @return boolean
   */
  public function saveTo($filename)
  {
    return move_uploaded_file($this->tmp_name,$filename);
  }

  /**
   * Read the content of an uploaded file.
   * @return string
   */
  public function read()
  {
    return file_get_contents($this->tmp_name);
  }

  /**
   * Upload fie exists??
   * @return boolean
   */
  public function getExists()
  {
    return fileExists($this->tmp_name);
  }
  
  /**
   * Upload success??
   * @return boolean
   */
  public function getSuccess()
  {
    return $this->error == UploadErrorEnum::UPLOAD_ERR_OK;    
  }
  
  /**
   * Extension of the uploaded file.
   * @return string
   */
  public function getExtension()
  {
    return pathinfo($this->name, PATHINFO_EXTENSION);
  }
  
  /**
   * 
   * @return string
   */
  public function getErrorString()
  {
    return UploadErrorEnum::getKey($this->error);    
  }  
}
