#= require ./module

class window.Behavior extends window.Module
  constructor: (@dom, @options = {}) ->
    @$dom = $(@dom)
    klass = @getClassName()
    unless @$dom.data(klass)
      @$dom.data(klass, true)
      @init()

  data: (attr, def=null) ->
    @options[attr] || @$dom.data(attr) || def

  domData: (attr) ->
    $(@data(attr))

  attachBehaviors: (data = {}) ->
    $.publish('behaviors.attach', data)

  getClassName: ->
    results = @constructor.toString().match(/^function ([^(]+)\(/)
    if results
      results[1]
    else
      "defaultClass"

  init: () ->
    throw new Error('I am an abstract class!')
