$(window).on('load', function () {
    var currentVehicleInfo = {
        plate: "N/A",
        maker: "N/A",
        model: "N/A",
        color: "N/A",
        firstRegDate: "N/A",
        latestRegistration: "N/A",
        vehicleGroup: "N/A"
    };
    var pendingRequest;
    var requestRunning = false;
    var timeout;
    $('#Event_Plate').tooltip({
        title: 'Querying national database...'
    });
    $('#Event_Plate').data('tooltip').options.html = true;
    $('#Event_Plate').data('tooltip').options.placement = "right";
    $('#Event_Plate').data('tooltip').options.title = "<b>Querying national database...</b>";


    $('#Event_Plate').keyup(function (e) {
        clearTimeout(timeout);
        timeout = setTimeout((function () {
            getNewPlateICETRAInfo();
        }
        ), 800);
    });

    $('#Event_Plate').focus(function (e) {
        clearTimeout(timeout);
        timeout = setTimeout((function () {
            getNewPlateICETRAInfo();
        }
        ), 800);
    });

    $('#Event_Plate').hover(function (e) {
        getNewPlateICETRAInfo();
    });

    getNewPlateICETRAInfo = function () {
        let currentPlate = $('#Event_Plate').val();
        if (currentPlate.length > 0 && !requestRunning && pendingRequest !== currentPlate) {
            $('#Event_Plate').data('tooltip').options.title = "<b>Querying national database...</b>";
            $('#Event_Plate').tooltip("show");
            pendingRequest = currentPlate;
            requestRunning = true;
            return $.ajax({
                type: "GET",
                url: settings.baseUrl + "/event/getIcetraDetails?plate=" + currentPlate,
                success: function (html) {
                    requestRunning = false;
                    if (html !== "NA") {
                        currentVehicleInfo = JSON.parse(html);
                        $('#Event_Plate').data('tooltip').options.title = "<b>Vehicle info:</b><br><table><tbody><tr>";
                        $('#Event_Plate').data('tooltip').options.title += "<tr><td align='left'><b>Plate:</b></td> <td align='right'><i>" + currentVehicleInfo.plate + "</i></td></tr>";
                        $('#Event_Plate').data('tooltip').options.title += "<tr><td align='left'><b>Maker:</b></td> <td align='right'><i>" + currentVehicleInfo.maker + "</i></td></tr>";
                        $('#Event_Plate').data('tooltip').options.title += "<tr><td align='left'><b>Model:</b></td> <td align='right'><i>" + currentVehicleInfo.model + "</i></td></tr>";
                        $('#Event_Plate').data('tooltip').options.title += "<tr><td align='left'><b>Color:</b></td> <td align='right'><i>" + currentVehicleInfo.color + "</i></td></tr>";
                        $('#Event_Plate').data('tooltip').options.title += "<tr><td align='left'><b>Vehicle category:</b></td> <td align='right'><i>" + currentVehicleInfo.vehicleGroup + "</i></td></tr>";
                        $('#Event_Plate').data('tooltip').options.title += "<tr><td align='left'><b>First registration:</b></td> <td align='right'><i>" + currentVehicleInfo.firstRegDate + "</i></td></tr>";
                        $('#Event_Plate').data('tooltip').options.title += "<tr><td align='left'><b>Latest registration:</b></td> <td align='right'><i>" + currentVehicleInfo.latestRegistration + "</i></td></tr></tbody></table>";
                    } else {
                        $('#Event_Plate').data('tooltip').options.title = "<b>Plate not found in the national database.</b>";
                    }
                    $('#Event_Plate').tooltip("show");
                },
                error: function (message) {
                    $('#Event_Plate').data('tooltip').options.title = "<b>There was an error querying the national database.</b>";
                }
            });
        }
    };
}
);