$(window).on('load', function () {
    $('.panel-collapse').on('shown.bs.collapse', function (e) {
        return $($(this).attr("id")).html(updateSelectedGateStatus($(this).attr("id")));
    });
    $('.panel-collapse').on('hidden.bs.collapse', function (e) {
    });


    checkForUpdates = function () {
        $.getScript('js/DateFormatter.js', function () {
            $('#gate-last-update-time').html(DateFormatter.format(new Date(), "Y/m/d H:i:s"));
        });
        $('.panel-collapse').each(function () {
            if ($(this).attr("class").indexOf("collapse in") >= 0) {
//                return $($(this).attr("id")).html(updateSelectedGateStatus($(this).attr("id")));
                updateSelectedGateStatus($(this).attr("id"));
            }
        });
    };

    updateSelectedGateStatus = function (gateId) {
        $.ajax({
            type: "GET",
            url: settings.baseUrl + "/gatesStatus/viewGateList/" + gateId,
            success: function (html) {
                return $('#' + gateId).html(html);
            }
        });
    };

//    updateAllGateGroupsStatuses = function () {
//        $.ajax({
//            type: "GET",
//            datatype: "json",
//            url: settings.baseUrl + "/gatesStatus/viewCurrentGateStatus/",
//            success: function (gatesArray) {
//                gatesArray.each(function (gateId, gateStatusClass) {
//                    updateGateCssClass(gateId, gateStatusClass);
//                });
//            }
//        });
//    };
    updateAllGateGroupsStatuses = function () {
        $.getJSON(settings.baseUrl + "/gatesStatus/viewCurrentGateStatus/", function (data) {
            $.each(data, function (gateId, gateStatusClass) {
                updateGateCssClass(gateId, gateStatusClass);
            });
        });
    };

    updateGateCssClass = function (gateId, gateClass) {
        $('#' + gateId).attr('class',
                function (i, c) {
                    return c.replace(/status-\S+/g, gateClass);
                });
        headingLink = $('#' + gateId).siblings('div').children('a').attr('class',
                function (i, c) {
                    return c.replace(/status-\S+/g, gateClass);
                });
    };

    setInterval(checkForUpdates, settings.gate_status_refresh_time);
    setInterval(updateAllGateGroupsStatuses, settings.gate_status_refresh_time);

}
);

$(function () {
    initializeAlertPanelAjax = function () {
        $.ajax({
            type: "GET",
            url: settings.baseUrl + "/gatesStatus/viewAlertsTable/",
            success: function (html) {
                return $('#alerts-container').html(html);
            }
        });
    };

    initializeAlertPanelAjax();
});

 